import os
import subprocess
LAST_EXCEPTION = None

def decode(s):
    ret = ''
    while '\\' in s:
        prefix, suffix = s.split('\\',1)
        ret += prefix
        if suffix.startswith('x'):
            ret += chr(int(suffix[1:3],16))
            s = suffix[3:]
    ret += s
    return ret

def jsname(js):
    return decode(js.get('ID_VENDOR_ENC','?'))+' '+decode(js.get('ID_MODEL_ENC','?'))

def list_controllers():
    # Return a tuple of all controllers.
    global LAST_EXCEPTION
    try:
        files = os.listdir('/dev/input/')
    except Exception,e:
        LAST_EXCEPTION=e
        return ()

    global controllers
    controllers = []
    ret = []
    for fn in files:
        if fn.startswith('event'):
            try:
                output = subprocess.check_output(['udevadm','info','-q','all','--name=input/'+fn])
            except Exception,e:
                LAST_EXCEPTION = e
                continue
            js = dict()
            for line in output.split('\n'):
                if line.startswith('E: '):
                    n, v = line[3:].split('=',1)
                    js[n] = v
                if line == 'E: ID_INPUT_JOYSTICK=1':
                    ret.append(('/dev/input/'+fn, js))
    return tuple(ret)
