import sys
import safepickle
import bz2
import hashlib

class RenpyArchive(object):
    # Used by the spiky signer to analyse an rpa and build range sums.
    # Should be easy enough to get backupfs extents, as well.
    version = 0
    f = None
    def __init__(self, filename):
        self.filename = filename
        self.Open()
        line = self.f.readline()
        if line.startswith('RPA-3.0 '):
            self.version = 3
        else:
            return
        self.index_offset = int(line[8:24], 16)
        self.key = int(line[25:33],16)
        self.f.seek(self.index_offset)
        index_pickle = self.f.read().decode('zlib')
        self.total_file_size = self.f.tell()
        index_decoded = safepickle.decode(index_pickle)
        self.index = dict()
        for k,v in index_decoded.iteritems():
            if len(v)!=1:
                print "v too long."
                continue
            v = v[0]
            if len(v)!=3:
                print "v!=3"
                continue
            if v[2] != '':
                continue
            offset = v[0]^self.key
            if offset<33 or offset>self.total_file_size:
                # No offsets outside the RPA
                continue
            length = v[1]^self.key
            if length<0 or length+offset>self.total_file_size:
                # No negative lengths, no lengths outside the RPA.
                continue
            self.index[k] = (offset, length, v[2])
    def Open(self):
        if self.f is not None:
            return
        if self.filename.endswith('.bz2'):
            self.f = bz2.BZ2File(self.filename,'rb')
        else:
            self.f = file(self.filename, 'rb')
    def ReadFile(self,fn):
        self.Open()
        f.seek(self.index[fn][0])
        return f.read(self.index[fn][1])
    def Ranges(self):
        self.Open()
        values = self.index.values()
        values.sort()
        i = 0
        ret = []
        for offset, length, start in values:
            if length<=64:
                print "Skipped short chunk",length
                # Don't bother summing 0-length chunks.
                # Don't bother summing chunks shorter than the checksum, we
                # can just merge them.
                continue
            if offset>i:
                self.f.seek(i)
                ret.append((i, offset-i,'o>i'))
            ret.append((offset,length))
            i = offset+length
        if i<self.total_file_size:
            ret.append((i, self.total_file_size-i))
        return ret
    def Rangesums(self):
        # Return a list of all ranges and checksums.
        self.Open()
        sums = []
        for r in self.Ranges():
            if not r[1]:
                raise Exception("Zero-length range.")
            self.f.seek(r[0])
            s = self.f.read(r[1])
            digest = hashlib.sha256(s).hexdigest()
            sums.append((r[0], r[1], digest))
        return sums
    def DigestedRanges(self):
        # Return a dict of all ranges, using the hashes as keys.
        ret = dict()
        for rangesum in self.Rangesums():
            ret[rangesum[2]] = rangesum
        return ret

class SyncableArchive(object):
    # This is designed for use by the in-game updater, to allow partial
    # download.
    def __init__(self, fn, ranges):
        self.filename = fn
        # ranges is a sorted list of all ranges the RPA should have.
        # Each range is a 3-tuple: offset, len, sha256.
        self.ranges = ranges
        self.present = set()
    def Create(self):
        self.f = file(self.filename, 'wb')
    def Open(self):
        self.f = file(self.filename, 'rb')
    def Close(self):
        if self.f is not None:
            self.f.close()
            self.f = None
    def SlurpMatchingRanges(self, src_rpa):
        # Fill in all ranges we need from src_rpa.
        # src_rpa is a RenpyArchive() object, containing a preexisting intact
        # .rpa.
        src_digested = src_rpa.DigestedRanges()
        for cand in self.ranges:
            if cand[2] in src_digested:
                if cand[1]==src_digested[cand[2]][1]:
                    # Length has to match, offset doesn't.
                    src_rpa.Open()
                    src_rpa.f.seek(src_digested[cand[2]][0])
                    s = src_rpa.f.read(src_digested[cand[2]][1])
                    self.f.seek(cand[0])
                    self.f.write(s)
                    self.present.add(cand[2])
                else:
                    print "Sha256 hash collision?",cand,src_digested[cand[2]]
                    raise Exception("Sha256 hash collision!")
    def RangesNeeded(self):
        needed = [(0,0)]
        last = (0,0,[])
        for cand in self.ranges:
            if cand[2] in self.present:
                continue
            if cand[0]==last[0]+last[1]:
                last = (last[0], last[1]+cand[1],last[2])
                last[2].append(cand)
                needed[-1] = last
            else:
                last = (cand[0], cand[1], [cand])
                needed.append(last)
        if needed and needed[0][1]==0:
            del needed[0]
        return needed

#for arg in sys.argv[1:]:
#    print len(RenpyArchive(arg).ranges())
