class Mark:
    pass

def ord32(s):
    assert len(s)==4
    return ord(s[0])+(ord(s[1])<<8)+(ord(s[2])<<16)+(ord(s[3])<<24)

def decode(s):
    if s[0:2]!='\x80\x02':
        raise Exception("Only pickle protocol 2 is supported.")
    i = 2
    memo = dict()
    stack = []
    while i<len(s):
        if s[i]=='(':
            stack.append(Mark)
        elif s[i]=='.':
            if i<len(s)-1:
                print "ERROR: Stop before end of string."
            return stack[-1]
        elif s[i]=='J':
            stack.append(ord(s[i+1])+(ord(s[i+2])<<8)+(ord(s[i+3])<<16)+(ord(s[i+4])<<24))
            i += 4
        elif s[i]=='U':
            # SHORT_BINSTRING
            strlen = ord(s[i+1])
            stack.append(s[i+2:i+2+strlen])
            i += strlen+1
        elif s[i]=='X':
            # Unicode string
            strlen = ord32(s[i+1:i+5])
            stack.append(s[i+5:i+5+strlen].decode('utf-8'))
            i += 4+strlen
        elif s[i]==']':
            stack.append([])
        elif s[i]=='a':
            stack[-2].append(stack.pop())
        elif s[i]=='q':
            i += 1
            memo[ord(s[i])] = stack[-1]
        elif s[i]=='r':
            memo[ord32(s[i+1:i+5])] = stack[-1]
            i += 4
        elif s[i]=='s':
            # dict setitem.
            stack[-3][stack[-2]] = stack[-1]
            stack = stack[:-2]
        elif s[i]=='u':
            pos = -1
            while stack[pos] is not Mark:
                pos -= 1
            d = stack[pos-1]
            x = pos+1
            while x<0:
                d[stack[x]] = stack[x+1]
                x += 2
            stack = stack[:pos]
        elif s[i]=='}':
            stack.append(dict())
        elif s[i]=='\x87':
            new = tuple(stack[-3:])
            stack.pop()
            stack.pop()
            stack[-1] = new
        else:
            print "Unexpected character 0x%02x"%ord(s[i]),s[i],'at byte',i
            raise Exception("Boom.")
        i += 1
