import renpy

shift_reloading = False
def allow_shift_reload():
    global shift_reloading
    shift_reloading=True
    try:
        del NamedTransform.__setstate__
    except Exception,e:
        print e

class NamedTransform(object):
    # These are basically just keys that can be used to look up transforms in
    # the transforms_by_name dict
    def __init__(self, name, func):
        self.name = name
    def __call__(self,*args,**kwargs):
        ret = transforms_by_name[self.name](*args,**kwargs)
        if ret.varname is None:
            if ret.parameters.positional:
                print "Debug 12",ret.parameters.positional
            ret.varname = self.name
        return ret
    def __repr__(self):
        try:
            ret = '<NamedTransform '+self.name+(' 0x%x'%id(self))+'>'
        except:
            return object.__repr__(self)
        return ret
    def __setstate__(self, state):
        raise Exception("Pickles verboten.")

"""
class NamedTransformWithArgs(NamedTransform):
    def __init__(self, namedtransform, *args):
        self.args = args
        self.name = name
    def __call__(self):
        ...
"""

transforms_by_name = dict()

def build_named_transform_list(source):
    renpy.display.motion.ATLTransform.varname = None
    for name in dir(source):
        v = getattr(source,name)
        if type(v) is renpy.display.motion.ATLTransform:
            if getattr(v,'varname',None) is not None and v.varname!=name:
                print "Transform already has a name:",name,v.varname
                raise Exception("Error: multiname transform.")
            v.varname = name
            if name in transforms_by_name:
                if shift_reloading:
                    print "Shift-reload permitting duplicate transform",v.varname
                else:
                    raise Exception("There already is a transform by that name.")
            transforms_by_name[name] = v
            setattr(source, name, NamedTransform(name, v))

def init():
    build_named_transform_list(renpy.store)
