# Unicode replacement for os.environ.

import ctypes

def getenvu(name):
    name = unicode(name.upper())
    n = ctypes.windll.kernel32.GetEnvironmentVariableW(name, None, 0)
    if n==0:
        return None
    # I may be padding more than is necessary here.  Caution is advised when
    # dealing with this sort of thing, though.
    buf = ctypes.create_unicode_buffer(n+1)
    buf[n] = unichr(0)
    n2 = ctypes.windll.kernel32.GetEnvironmentVariableW(name, buf, n)
    if not n2:
        # Something deleted the env variable, or there was an error.
        raise Exception("GetEnvironmentVariableW")
    return buf.value

def putenvu(name, value):
    name = unicode(name.upper())
    if not value:
        if not ctypes.windll.kernel32.SetEnvironmentVariableW(name):
            raise KeyError(name)
        return
    value = unicode(value)
    if not ctypes.windll.kernel32.SetEnvironmentVariableW(name, value):
        raise Exception("SetEnvironmentVariableW")

def clearenvu(name, value):
    name = name.upper()
    if not ctypes.windll.kernel32.SetEnvironmentVariableW(name):
        raise KeyError(name)

class Environ(dict):
    def __getitem__(env, k):
        ret = getenvu(k)
        if ret is None:
            raise KeyError(k)
        return ret
    def __setitem__(env, k, v):
        return putenvu(k, v)
    def __delitem__(env, k):
        return clearenvu(k,v)
    def __contains__(env, name):
        name = unicode(name.upper())
        n = ctypes.windll.kernel32.GetEnvironmentVariableW(name, None, 0)
        if n>0:
            return True
        return False
    def pop(env, k, *args):
        ret = getenvu(k)
        if ret is None:
            if args:
                return args[0]
            else:
                raise KeyError(k)
        clearenvu(k)
        return ret
    def get(env, k, default=None):
        ret = getenvu(k)
        if ret is not None:
            return ret
        return default
